uniform sampler3D volumeTexture;
uniform sampler1D transferTexture;
uniform sampler2D frontTexture;
uniform sampler2D backTexture;
uniform sampler2D colorTexture;
uniform float stepDist;
uniform int startStep;

void main()
{
	vec4 startPoint = texture2D(frontTexture, gl_TexCoord[0].st);

	if(startPoint.w == 0.0)
	{
		discard;
	}
	else
	{
		vec4 endPoint = texture2D(backTexture, gl_TexCoord[0].st);
		vec4 oldFullColor = texture2D(colorTexture, gl_TexCoord[0].st);
		vec3 iterDiff = (endPoint.xyz - startPoint.xyz) * stepDist;

		vec3 currPoint = startPoint.xyz + iterDiff * startStep;
		vec3 color = oldFullColor.xyz;
		float alpha = oldFullColor.w;

		for(int i = 0;i < #;i++)
		{
			float intensity = clamp(texture3D(volumeTexture, currPoint).x, 0.0, 0.999);
			vec4 newFullColor = texture1D(transferTexture, intensity);

			float newAlpha = newFullColor.a;
			vec3 newColor = newFullColor.rgb * newAlpha;
		
			color = color + (1.0 - alpha) * newColor; 
			alpha = alpha + (1.0 - alpha) * newAlpha;

			currPoint += iterDiff;
		}
		
		gl_FragColor = vec4(color, alpha);
	}
}